function isAnalyst() {
	try {
		return window.external.isAnalyst();
	} catch (exception) {}
	return false;
}

function executeScript() {
	try {
		eval(jQuery('#scriptContainer').val());
		$('#lastScriptExecuted').html('Last script executed<br />' + jQuery('#scriptContainer').val());
	} catch (err) {
		$('#lastScriptExecuted').html('<b style="color: red">Error</b><br />' + err);
	}
}

function toggleConfig() {
	jQuery('#configBlock').animate({
		height: "toggle"
	}, {
		complete: function() {
			$(this).toggleClass('collapsed');
			$('#toggleButton').text($(this).hasClass('collapsed') ? 'show' : 'hide');
		}
	})
}

function createSpotfireDocument() {
	var serverUrl = jQuery('#spotfireServerUrl').val();
	var analysisPath  = jQuery('#analysisPath').val();
	var configurationBlockText = jQuery('#configurationBlockText').val();
	
	window.spotfireDocument = new SpotfireDocument(
		serverUrl,
		analysisPath,
		function(err) {
			if (err) {
				alert(typeof err.toString() !== '[object Object]' ? err : JSON.stringify(err));
			} else {
				console.log('Document ' + analysisPath + ' opened');
				alert('Document loaded');
				toggleConfig();
			}
		},
		configurationBlockText
	);
}

function loadSpotfire() {
	var serverUrl = jQuery('#spotfireServerUrl').val();
	var apiUrl = jQuery('#spotfireAPIUrl').val();
	var analysisPath  = jQuery('#analysisPath').val();
	
	if (!serverUrl) {
		alert('Please indicate a valid server URL');
		return;
	}
	
		
	if (isAnalyst() && !apiUrl) {
		alert('Please indicate a valid API URL');
		return;
	}

	if (isAnalyst()) {
		createSpotfireDocument();
	} else {
		jQuery.getScript(apiUrl).done(function() {
			if (typeof analysisPath === 'undefined') {
				analysisPath = window.DEFAULT_ANALYSIS_PATH;
			}
			createSpotfireDocument();
		});
	}
}

jQuery(document).ready(function() {
    jQuery('#host').text(window.location.host);
	
	if (isAnalyst()) {
		$('#debugTool').addClass('analyst');
		$('.col.wide').width(0);
	}
	
	jQuery.get('./config.json').done(function(config) {
		if (!config) {
			return;
		}
		if (config.spotfireServerUrl) {
			jQuery('#spotfireServerUrl').val(config.spotfireServerUrl)
		}
		if (config.spotfireAPIUrl) {
			jQuery('#spotfireAPIUrl').val(config.spotfireAPIUrl)
		}
		if (config.analysisPath) {
			jQuery('#analysisPath').val(config.analysisPath)
		}
		if (config.configurationBlockText) {
			jQuery('#configurationBlockText').val(config.configurationBlockText)
		}
	})
    WEBTOOLKIT_DEBUG = true;
});
